<?php

$templateDir = __DIR__ . '/templates/';
$outputDir   = __DIR__ . '/output/';
$dataFile    = __DIR__ . '/data/data.json';

// Create output directory if not exists
if (!is_dir($outputDir)) {
    mkdir($outputDir, 0755, true);
}

// Load JSON data
$json = file_get_contents($dataFile);
$data = json_decode($json, true);

if (!$data) {
    die('Invalid JSON data');
}

// Loop through each template config
foreach ($data as $item) {

    if (empty($item['filename'])) {
        continue;
    }

    $templatePath = $templateDir . 'base-template.html';

    if (!file_exists($templatePath)) {
        die('Template file not found');
    }

    // Load HTML template
    $html = file_get_contents($templatePath);

    // Replace placeholders {{key}}
    foreach ($item as $key => $value) {
        $html = str_replace('{{' . $key . '}}', $value, $html);
    }

    // Save new HTML file
    $outputFile = $outputDir . $item['filename'];
    file_put_contents($outputFile, $html);

    echo "Generated: {$item['filename']}\n";
}

echo "All templates generated successfully.\n";
